# Protocol Analyzer Skill

Serial protocol analysis and debugging for I2C, SPI, and UART interfaces.

## Purpose

Provides protocol analysis capabilities for common embedded interfaces:
- I2C bus analysis and address detection
- SPI transaction decoding
- UART frame analysis
- Timing verification and compliance

## Key Features

- Multi-protocol support (I2C, SPI, UART)
- Transaction decoding and timing analysis
- Error detection and diagnosis
- Logic analyzer integration
- Protocol compliance verification

## Integration

Used by processes requiring protocol analysis:
- Device driver development
- Hardware bring-up validation
- Signal integrity testing
- BSP communication testing

## Dependencies

- Logic analyzer software (Saleae, Sigrok)
- Protocol decoder libraries
- Compatible logic analyzer hardware
