---
name: protocol-builder
description: Skill for building standardized research protocols
allowed-tools:
  - Read
  - Write
  - Bash
metadata:
  specialization: scientific-discovery
  domain: science
  category: Experimental Design
  skill-id: SK-SCIDISC-015
---

# Protocol Builder Skill

## Purpose

Build standardized research protocols following best practices for reproducibility, clarity, and completeness.

## Capabilities

- Generate protocol templates
- Structure methodology sections
- Include required elements
- Format for registration
- Support multiple domains
- Export in standard formats

## Usage Guidelines

1. Select protocol type
2. Define study parameters
3. Structure methodology
4. Include all elements
5. Review completeness
6. Export for registration

## Process Integration

Works within scientific discovery workflows for:
- Study registration
- Grant applications
- Ethics submissions
- Protocol publication

## Configuration

- Protocol templates
- Required sections
- Formatting standards
- Export options

## Output Artifacts

- Study protocols
- Registration documents
- Methods sections
- Protocol summaries
