# Protocol Fuzzer Skill

Expert skill for protocol fuzzing, vulnerability discovery, and security testing.

## Overview

This skill provides specialized capabilities for security testing of network protocols through fuzzing. It covers fuzzer configuration, mutation strategies, coverage analysis, and vulnerability reporting.

## Key Features

- AFL++, libFuzzer, boofuzz configuration
- Mutation strategy design
- Coverage-guided fuzzing
- Crash analysis and triage
- Security vulnerability reporting

## When to Use

- Security testing protocol implementations
- Finding memory corruption bugs
- Testing parser robustness
- Generating security test cases
- Vulnerability discovery

## Dependencies

- AFL++
- libFuzzer
- boofuzz
- radamsa
- honggfuzz
