---
name: psychometric-assessment
description: Develop, validate, and adapt measurement instruments including factor analysis, reliability testing, and cross-cultural validation
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Psychometric Assessment Skill

Develop, validate, and adapt measurement instruments using established psychometric methods and standards.

## Overview

The Psychometric Assessment skill enables development, validation, and adaptation of measurement instruments including factor analysis, reliability testing, item response theory, and cross-cultural validation for rigorous psychological and social measurement.

## Capabilities

### Scale Development
- Construct definition
- Item generation
- Expert review
- Cognitive interviewing
- Item refinement

### Factor Analysis
- Exploratory factor analysis
- Confirmatory factor analysis
- Model fit assessment
- Factor extraction
- Rotation methods

### Reliability Assessment
- Internal consistency
- Test-retest reliability
- Inter-rater reliability
- Measurement error
- Reliability improvement

### Validity Evidence
- Content validity
- Criterion validity
- Construct validity
- Convergent/discriminant validity
- Predictive validity

### Cross-Cultural Adaptation
- Translation procedures
- Cultural equivalence
- Measurement invariance
- Differential item functioning
- Adaptation validation

## Usage Guidelines

### When to Use
- Developing new measures
- Validating instruments
- Adapting scales
- Assessing measurement quality
- Improving instruments

### Best Practices
- Follow standards
- Document thoroughly
- Test in target population
- Assess multiple validity types
- Report comprehensively

### Integration Points
- Quantitative Methods skill
- Survey Design and Administration skill
- Research Ethics and IRB skill
- Mixed Methods Integration skill

## References

- Scale Development and Validation process
- Cross-Cultural Measurement Adaptation process
- Measurement and Psychometrics Expert agent
