---
name: pyramid-structuring
description: Structure analysis and presentations using the Pyramid Principle with SCQA and MECE frameworks
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
metadata:
  specialization: business-analysis
  domain: business
  id: SK-010
  category: Communication
---

# Pyramid Principle Structuring

## Overview

The Pyramid Principle Structuring skill provides specialized capabilities for structuring analysis and presentations using Barbara Minto's Pyramid Principle. This skill enables clear, compelling communication through logical structuring, SCQA format, MECE grouping, and executive-ready storyline development.

## Capabilities

### SCQA Format Structuring
- Structure arguments in SCQA format (Situation, Complication, Question, Answer)
- Create compelling opening hooks
- Build logical narrative flow
- Generate executive-ready introductions

### MECE Grouping
- Apply MECE grouping to analysis points (Mutually Exclusive, Collectively Exhaustive)
- Validate logical groupings
- Identify gaps and overlaps
- Reorganize content for clarity

### Executive Summary Generation
- Generate executive summaries from detailed analysis
- Apply "answer first" principle
- Create one-page executive briefs
- Synthesize key insights and recommendations

### Storyline Flow Creation
- Create storyline flow for presentations
- Build logical argument chains
- Connect insights to recommendations
- Design persuasive narrative arcs

### Logical Structure Validation
- Validate logical structure of arguments
- Check for proper grouping and ordering
- Identify logical fallacies
- Verify conclusion support

### Pyramid Diagram Generation
- Generate pyramid structure diagrams
- Visualize argument hierarchy
- Show supporting points at each level
- Create visual summaries

### Slide Storyboarding
- Create slide-by-slide storyboards
- Define key message per slide
- Outline supporting content
- Design visual layout recommendations

## Usage

### Structure with SCQA
```
Structure this analysis using SCQA format:
[Analysis content]

Create a compelling introduction and logical flow.
```

### Apply MECE Grouping
```
Apply MECE grouping to these points:
[List of analysis points]

Reorganize into mutually exclusive, collectively exhaustive groups.
```

### Generate Executive Summary
```
Generate an executive summary from this detailed analysis:
[Detailed analysis content]

Apply answer-first principle and limit to one page.
```

### Create Presentation Storyline
```
Create a presentation storyline for this recommendation:
[Recommendation and supporting analysis]

Design slide-by-slide storyboard with key messages.
```

## Process Integration

This skill integrates with the following business analysis processes:
- executive-presentation.js - Core presentation structuring
- business-case-development.js - Business case communication
- hypothesis-driven-analysis.js - Analysis structuring
- consulting-engagement-planning.js - Client communication

## Dependencies

- Document structuring algorithms
- Presentation templates
- Pyramid diagram generation
- Logical validation rules

## Pyramid Principle Reference

### SCQA Framework
| Element | Purpose | Question Answered |
|---------|---------|-------------------|
| Situation | Set context | What do we all agree on? |
| Complication | Create tension | What changed or went wrong? |
| Question | Focus attention | What should we do about it? |
| Answer | Provide solution | Here's what we recommend |

### MECE Principles
**Mutually Exclusive**: No overlap between groups
- Each item belongs to only one category
- Categories are clearly distinct
- No double-counting

**Collectively Exhaustive**: Nothing missing
- All possibilities are covered
- No gaps in the logic
- Complete coverage of the topic

### Pyramid Structure Rules
1. **Start with the answer**: Lead with your conclusion
2. **Group and summarize**: Organize supporting points
3. **Logically order**: Use deductive or inductive logic
4. **Apply MECE**: Ensure logical grouping

### Logical Ordering Options
| Order Type | When to Use | Example |
|------------|-------------|---------|
| Time | Sequential events | Phase 1, Phase 2, Phase 3 |
| Structure | Organizational units | Region A, Region B, Region C |
| Importance | Prioritized items | Critical, Important, Nice-to-have |
| Process | Workflow steps | Input, Process, Output |
| Comparison | Evaluating options | Option A vs B vs C |

### Deductive vs Inductive Arguments
**Deductive** (Argument):
- Major premise (rule)
- Minor premise (case)
- Conclusion (result)

**Inductive** (Grouping):
- Group similar ideas
- Summarize the group
- Draw conclusion from pattern

### Slide Storyboard Template
```
Slide Title: [Action title - key message]
Key Message: [One sentence takeaway]
Supporting Points:
- [Point 1]
- [Point 2]
- [Point 3]
Visual: [Chart/diagram recommendation]
Transition: [Link to next slide]
```

### Executive Summary Structure
1. **Headline**: Answer in one sentence
2. **Context**: Brief situation/complication
3. **Key findings**: 3-5 bullet points (MECE)
4. **Recommendation**: Clear call to action
5. **Next steps**: Immediate actions required
