---
name: qec-code-builder
description: Quantum error correction code implementation skill for fault-tolerant quantum computing
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: quantum-computing
  domain: science
  category: error-management
  phase: 6
---

# QEC Code Builder

## Purpose

Provides expert guidance on quantum error correction code implementation, enabling fault-tolerant quantum computing through encoding, syndrome extraction, and logical operations.

## Capabilities

- Surface code implementation
- Steane code [[7,1,3]] construction
- Color code implementation
- Repetition code for testing
- Syndrome extraction circuits
- Logical gate implementations
- Code distance optimization
- Threshold analysis

## Usage Guidelines

1. **Code Selection**: Choose QEC code based on error model and resource constraints
2. **Encoding Design**: Implement logical qubit encoding circuits
3. **Syndrome Extraction**: Design efficient syndrome measurement schedules
4. **Decoder Integration**: Connect to appropriate decoding algorithms
5. **Logical Operations**: Implement fault-tolerant logical gates

## Tools/Libraries

- Stim
- PyMatching
- QLDPC
- Qiskit
- Cirq
