---
name: qiskit-quantum-simulator
description: Qiskit quantum computing skill for circuit design, simulation, and quantum algorithm development
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: physics
  domain: science
  category: quantum-mechanics
  phase: 6
---

# Qiskit Quantum Simulator

## Purpose

Provides expert guidance on Qiskit quantum computing, including circuit construction, simulation, and quantum algorithm implementation.

## Capabilities

- Quantum circuit construction
- Statevector and density matrix simulation
- Noise modeling and mitigation
- Variational algorithm implementation (VQE, QAOA)
- IBM Quantum backend submission
- Quantum chemistry integration (Qiskit Nature)

## Usage Guidelines

1. **Circuit Design**: Build quantum circuits with Qiskit primitives
2. **Simulation**: Run circuits on statevector or noise simulators
3. **Algorithms**: Implement variational algorithms
4. **Hardware**: Submit jobs to IBM Quantum backends
5. **Chemistry**: Use Qiskit Nature for molecular simulations

## Tools/Libraries

- Qiskit
- Qiskit Nature
- Qiskit Aer
