---
name: qsharp-compiler
description: Microsoft Q# skill for quantum algorithm development with the Q# language and Azure Quantum integration
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: quantum-computing
  domain: science
  category: quantum-framework
  phase: 6
---

# Q# Compiler

## Purpose

Provides expert guidance on quantum algorithm development using Microsoft Q# language, enabling resource estimation and deployment to Azure Quantum backends.

## Capabilities

- Q# program compilation and execution
- Resource estimation for quantum algorithms
- Integration with Azure Quantum
- Quantum simulation with QDK
- T-gate counting and depth analysis
- Quantum chemistry libraries (Microsoft.Quantum.Chemistry)
- Type-safe quantum programming
- Classical-quantum interop

## Usage Guidelines

1. **Program Structure**: Organize Q# code with operations, functions, and namespaces
2. **Type System**: Leverage Q# type system for quantum-safe programming
3. **Resource Estimation**: Use resource estimator for algorithm feasibility analysis
4. **Azure Integration**: Configure Azure Quantum workspace for hardware execution
5. **Testing**: Write unit tests for quantum operations using Q# testing framework

## Tools/Libraries

- Q#
- Quantum Development Kit (QDK)
- Azure Quantum
- IQ# kernel
- VS Code Q# extension
