---
name: qualitative-analysis
description: Conduct systematic qualitative data analysis using grounded theory, thematic analysis, and content analysis with NVivo or Atlas.ti
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Qualitative Analysis Skill

Conduct systematic qualitative data analysis using established methodological approaches and specialized software.

## Overview

The Qualitative Analysis skill enables systematic qualitative data analysis using grounded theory, thematic analysis, content analysis, and other established approaches with NVivo, Atlas.ti, or other qualitative data analysis software for rigorous interpretive research.

## Capabilities

### Grounded Theory
- Open coding
- Axial coding
- Selective coding
- Constant comparison
- Theoretical saturation

### Thematic Analysis
- Familiarization
- Code generation
- Theme development
- Theme review
- Theme definition

### Content Analysis
- Category development
- Coding schemes
- Reliability assessment
- Frequency analysis
- Pattern identification

### Software Proficiency
- NVivo workflows
- Atlas.ti procedures
- MAXQDA methods
- Dedoose usage
- Manual coding systems

### Quality Assurance
- Intercoder reliability
- Member checking
- Audit trails
- Negative case analysis
- Reflexivity documentation

## Usage Guidelines

### When to Use
- Analyzing interview data
- Examining documents
- Exploring phenomena
- Building theory
- Understanding meaning

### Best Practices
- Document analytical decisions
- Maintain audit trail
- Check interpretations
- Engage with data iteratively
- Report transparently

### Integration Points
- Ethnographic Research skill
- Interview and Facilitation skill
- Mixed Methods Integration skill
- Systematic Review skill

## References

- Qualitative Coding and Analysis process
- Grounded Theory Development process
- In-Depth Interview Protocol process
- Qualitative Research Specialist agent
