---
name: quality-assurance-review
description: Conduct systematic quality reviews of instructional materials using established rubrics (Quality Matters) and design standards
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Quality Assurance Review

Conduct systematic quality reviews of instructional materials using established rubrics such as Quality Matters and instructional design standards.

## Overview

This skill enables systematic quality review of instructional materials and courses. It encompasses application of quality standards, rubric-based evaluation, feedback provision, and continuous improvement to ensure high-quality learning experiences.

## Capabilities

### Standards Application
- Apply Quality Matters rubric
- Use instructional design standards
- Evaluate accessibility compliance
- Assess alignment quality
- Check technical functionality

### Review Process
- Conduct systematic reviews
- Document findings thoroughly
- Provide constructive feedback
- Prioritize improvements
- Track resolution

### Feedback Communication
- Write clear feedback
- Explain standards requirements
- Offer improvement suggestions
- Acknowledge strengths
- Guide revision process

### Continuous Improvement
- Identify patterns across reviews
- Recommend systemic changes
- Track quality metrics
- Support reviewer calibration
- Update standards application

## Usage Guidelines

### Review Process
1. Prepare review materials
2. Apply rubric systematically
3. Document observations
4. Assess each standard
5. Compile findings
6. Write feedback report
7. Support improvement

### Quality Criteria
- Alignment of objectives, activities, assessments
- Clear navigation and organization
- Accessible and inclusive design
- Engaging instructional strategies
- Effective learner support

### Feedback Guidelines
- Be specific and actionable
- Reference standards clearly
- Provide examples
- Acknowledge effective elements
- Prioritize recommendations

## Integration Points

### Related Processes
- Quality Matters Course Review
- Program Accreditation Preparation
- E-Learning Course Authoring

### Collaborating Skills
- accessibility-compliance-auditing
- curriculum-gap-analysis
- learning-analytics-interpretation

## References

- Quality Matters rubric and standards
- OSCQR rubric
- Instructional design best practices
- Accessibility standards
