---
name: quality-metrics-measurement
description: Collect, calculate, and report healthcare quality metrics including core measures, HEDIS, patient safety indicators, and value-based purchasing measures
allowed-tools: Read, Grep, Write, Edit, Glob, Bash, WebFetch
---

# Quality Metrics Measurement

Collect, calculate, and report healthcare quality metrics including core measures, HEDIS, patient safety indicators, and value-based purchasing measures.

## Overview

This skill enables measurement and reporting of healthcare quality metrics. It encompasses data collection, metric calculation, benchmarking, and reporting to support quality improvement and regulatory compliance.

## Capabilities

### Core Measures
- CMS quality measures
- Joint Commission measures
- State-required metrics
- Specialty-specific measures
- Outcome measures

### HEDIS Metrics
- Effectiveness of care
- Access/availability
- Experience of care
- Utilization metrics
- Health plan measures

### Patient Safety Indicators
- AHRQ PSIs
- Hospital-acquired conditions
- Never events tracking
- Mortality indicators
- Complication rates

### Value-Based Metrics
- Value-based purchasing measures
- MIPS quality measures
- ACO quality metrics
- Bundled payment measures
- Risk adjustment

## Usage Guidelines

### Measurement Process
1. Identify required measures
2. Define data sources
3. Establish collection methods
4. Calculate metrics accurately
5. Validate data quality
6. Benchmark performance
7. Report results

### Data Quality
- Validate data completeness
- Verify accuracy
- Check for outliers
- Ensure consistency
- Document exceptions

### Reporting Standards
- Follow specification manuals
- Meet submission deadlines
- Use required formats
- Document methodology
- Maintain audit trails

## Integration Points

### Related Processes
- PDSA Cycle Implementation
- Quality Reporting Program Compliance
- HRO Implementation

### Collaborating Skills
- clinical-workflow-analysis
- patient-safety-event-analysis
- regulatory-compliance-assessment

## References

- CMS quality measure specifications
- NCQA HEDIS technical specifications
- AHRQ quality indicators
- Joint Commission standards
