---
name: quantum-kernel-estimator
description: Quantum kernel computation skill for quantum machine learning
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: quantum-computing
  domain: science
  category: quantum-ml
  phase: 6
---

# Quantum Kernel Estimator

## Purpose

Provides expert guidance on quantum kernel methods for machine learning, enabling kernel-based classifiers and regressors with quantum feature maps.

## Capabilities

- Fidelity quantum kernel
- Projected quantum kernel
- Kernel alignment optimization
- Feature map design
- SVM integration with quantum kernels
- Kernel matrix visualization
- Bandwidth tuning
- Trainable kernel circuits

## Usage Guidelines

1. **Feature Map Selection**: Design quantum feature map for data encoding
2. **Kernel Computation**: Calculate kernel matrix entries via circuit execution
3. **Alignment Optimization**: Tune kernel for target classification task
4. **SVM Training**: Use quantum kernel with classical SVM solvers
5. **Performance Evaluation**: Assess classification accuracy and quantum advantage

## Tools/Libraries

- Qiskit Machine Learning
- PennyLane
- scikit-learn
- CVXPY
- NumPy
