---
name: recurrence-solver
description: Solve recurrence relations using multiple methods including Master Theorem and generating functions
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: computer-science
  domain: science
  category: algorithm-analysis
  phase: 6
---

# Recurrence Solver

## Purpose

Provides expert guidance on solving recurrence relations arising from divide-and-conquer and recursive algorithm analysis.

## Capabilities

- Apply Master Theorem (all three cases)
- Substitution method with guess verification
- Recursion tree analysis with visualization
- Generating functions for complex recurrences
- Akra-Bazzi method for generalized recurrences
- Handle non-standard recurrence forms

## Usage Guidelines

1. **Recognition**: Identify recurrence structure and applicable methods
2. **Master Theorem**: Check and apply Master Theorem cases
3. **Substitution**: Formulate and verify guess for complex cases
4. **Tree Analysis**: Build recursion tree for intuition
5. **Verification**: Validate solutions with base cases

## Tools/Libraries

- SymPy
- Visualization libraries
- Symbolic algebra systems
