---
name: regen-braking
description: Regenerative braking system design and blending expertise
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
  - WebFetch
  - WebSearch
  - Bash
metadata:
  version: "1.0"
  category: automotive-engineering
  tags:
    - electrification
    - braking
    - regeneration
    - energy-recovery
---

# Regenerative Braking Skill

## Purpose
Provide regenerative braking system design and blending expertise for optimal energy recovery and pedal feel in electric vehicles.

## Capabilities
- Brake blending strategy design
- One-pedal driving implementation
- Regeneration limit management
- Brake-by-wire integration
- Wheel slip control during regen
- Energy recovery optimization
- Pedal feel calibration
- Coast regen tuning

## Usage Guidelines
- Design blending strategy for seamless transitions
- Implement one-pedal driving for user convenience
- Manage regeneration limits based on battery state
- Ensure wheel slip control during high regen
- Optimize energy recovery for range extension
- Calibrate pedal feel for consistent response

## Dependencies
- Brake system simulation tools
- dSPACE HIL

## Process Integration
- VDC-003: Brake System Development
- PTE-001: Battery System Design and Validation
- PTE-002: Electric Drive Unit Development
