---
name: replication-feasibility-assessor
description: Skill for assessing feasibility of study replication
allowed-tools:
  - Read
  - Write
  - Bash
metadata:
  specialization: scientific-discovery
  domain: science
  category: Quality Assurance
  skill-id: SK-SCIDISC-032
---

# Replication Feasibility Assessor Skill

## Purpose

Assess the feasibility of replicating published studies by evaluating method clarity, resource requirements, and material availability.

## Capabilities

- Evaluate method clarity
- Estimate resource needs
- Check material availability
- Assess expertise requirements
- Identify barriers
- Generate feasibility reports

## Usage Guidelines

1. Review study methods
2. Assess clarity
3. Estimate resources
4. Check availability
5. Identify barriers
6. Generate report

## Process Integration

Works within scientific discovery workflows for:
- Replication planning
- Study selection
- Resource estimation
- Feasibility analysis

## Configuration

- Assessment criteria
- Resource databases
- Barrier categories
- Report templates

## Output Artifacts

- Feasibility assessments
- Resource estimates
- Barrier analyses
- Replication plans
