---
name: research-ethics-irb-navigation
description: Prepare ethics applications, develop informed consent protocols, and navigate institutional review processes for human subjects research
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Research Ethics and IRB Navigation

Prepare ethics applications, develop informed consent protocols, and navigate institutional review processes for human subjects research.

## Overview

This skill enables ethical conduct of human subjects research. It encompasses ethics application preparation, informed consent development, and IRB process navigation to ensure research meets ethical standards and regulatory requirements.

## Capabilities

### Ethics Application
- Protocol development
- Risk assessment
- Benefit justification
- Population protection
- Methodology description

### Informed Consent
- Consent document drafting
- Plain language writing
- Comprehension verification
- Special populations
- Ongoing consent processes

### IRB Navigation
- Submission requirements
- Review categories
- Response to conditions
- Amendment procedures
- Renewal processes

### Ongoing Compliance
- Adverse event reporting
- Protocol modifications
- Annual reviews
- Audit preparation
- Record maintenance

## Usage Guidelines

### Application Process
1. Review IRB requirements
2. Develop research protocol
3. Assess risks and benefits
4. Draft consent documents
5. Complete application forms
6. Submit for review
7. Respond to conditions

### Consent Best Practices
- Use plain language
- Include all required elements
- Explain voluntariness
- Describe risks clearly
- Provide contact information

### Compliance Maintenance
- Follow approved protocol
- Report changes promptly
- Document consent process
- Maintain records
- Submit renewals timely

## Integration Points

### Related Processes
- Ethnographic Fieldwork Planning
- Research Ethics Review
- Oral History Collection Protocol

### Collaborating Skills
- oral-history-interview-technique
- ethnographic-coding-thematics
- grant-narrative-writing

## References

- Belmont Report
- Common Rule
- IRB guidelines
- Research ethics literature
