---
name: research-ethics-irb
description: Navigate institutional review board processes, informed consent, confidentiality, and ethical considerations in human subjects research
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Research Ethics and IRB Skill

Navigate IRB processes and ensure ethical practice in human subjects research across social science disciplines.

## Overview

The Research Ethics and IRB skill enables navigation of institutional review board processes, development of informed consent procedures, maintenance of confidentiality, and ethical practice in human subjects research across social science disciplines.

## Capabilities

### IRB Navigation
- Protocol preparation
- Exemption determination
- Expedited review
- Full board review
- Amendment procedures

### Informed Consent
- Consent document development
- Comprehension verification
- Ongoing consent
- Waiver conditions
- Special populations

### Confidentiality
- Data de-identification
- Secure storage
- Access control
- Certificate of Confidentiality
- Data sharing protocols

### Risk Assessment
- Risk identification
- Risk minimization
- Benefit assessment
- Vulnerable populations
- Monitoring procedures

### Ethical Practice
- Research integrity
- Conflict of interest
- Data management
- Publication ethics
- Community engagement

## Usage Guidelines

### When to Use
- Planning human subjects research
- Preparing IRB submissions
- Developing consent procedures
- Managing data ethically
- Addressing ethical issues

### Best Practices
- Plan ethics early
- Document thoroughly
- Protect participants
- Maintain transparency
- Seek guidance when uncertain

### Integration Points
- Survey Design and Administration skill
- Interview and Facilitation skill
- Ethnographic Research skill
- Qualitative Analysis skill

## References

- All research processes
- Research Ethics Coordinator agent
