---
name: retrospective-facilitator
description: Generate retrospective formats and analyze improvement actions
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
metadata:
  specialization: project-management
  domain: business
  category: Agile Management
  id: SK-015
---

# Retrospective Facilitator

## Overview

The Retrospective Facilitator skill supports Agile teams in conducting effective sprint retrospectives. It provides diverse retrospective formats, facilitates feedback collection, tracks improvement actions, and analyzes patterns across retrospectives to drive continuous team improvement.

## Capabilities

### Retrospective Formats
- Generate retrospective agenda templates (Starfish, 4Ls, Sailboat, Mad/Sad/Glad)
- Provide format variations for team freshness
- Support remote and in-person formats
- Create icebreaker activities
- Suggest formats based on team context

### Feedback Collection
- Create anonymous feedback collection mechanisms
- Structure feedback by category
- Enable dot voting and prioritization
- Facilitate discussion prompts
- Capture verbatim team input

### Action Management
- Categorize and prioritize improvement items
- Track action item completion across sprints
- Assign owners and due dates
- Follow up on outstanding actions
- Calculate action completion rates

### Analysis and Insights
- Generate retrospective summary reports
- Analyze patterns across multiple retrospectives
- Calculate team improvement velocity
- Identify recurring themes and blockers
- Correlate improvements with velocity/quality

## Usage

### Input Requirements
- Sprint/iteration context
- Team composition
- Previous action items
- Historical retrospective data (optional)
- Format preferences

### Output Deliverables
- Retrospective agenda/facilitation guide
- Feedback collection templates
- Action item register
- Retrospective summary report
- Pattern analysis insights

### Example Use Cases
1. **Sprint Retrospective**: Facilitate standard retro session
2. **Release Retrospective**: Conduct larger-scope review
3. **Action Follow-up**: Track improvement progress
4. **Team Health**: Analyze team improvement trends

## Process Integration

This skill integrates with the following processes:
- Sprint Retrospective Facilitation
- agile-metrics-velocity.js
- Lessons Learned and Knowledge Management
- Team Formation and Development

## Dependencies

- Templates library
- Feedback collection frameworks
- Pattern analysis utilities
- Action tracking systems

## Related Skills

- SK-005: Agile Metrics Calculator
- SK-010: Sprint Planning Calculator
- SK-018: Lessons Learned Repository
