---
name: revenue-cycle-analytics
description: Analyze revenue cycle performance metrics including denial rates, days in AR, clean claim rates, and collection efficiency to identify improvement opportunities
allowed-tools: Read, Grep, Write, Edit, Glob, Bash, WebFetch
---

# Revenue Cycle Analytics

Analyze revenue cycle performance metrics including denial rates, days in AR, clean claim rates, and collection efficiency to identify improvement opportunities.

## Overview

This skill enables analysis of revenue cycle performance in healthcare organizations. It encompasses metric calculation, trend analysis, benchmarking, and improvement opportunity identification to optimize financial performance.

## Capabilities

### Key Metrics
- Denial rates and reasons
- Days in accounts receivable
- Clean claim rates
- Collection rates
- Net revenue per encounter

### Trend Analysis
- Historical trending
- Variance analysis
- Seasonality patterns
- Payer performance
- Service line analysis

### Benchmarking
- Industry comparisons
- Peer benchmarking
- Best practice targets
- Performance gaps
- Improvement opportunities

### Root Cause Analysis
- Denial analysis
- Write-off review
- Underpayment identification
- Process breakdown
- Payer issues

## Usage Guidelines

### Analysis Process
1. Define metrics and KPIs
2. Collect and validate data
3. Calculate performance measures
4. Analyze trends and patterns
5. Benchmark against targets
6. Identify root causes
7. Develop recommendations

### Key Performance Areas
- Front-end (eligibility, authorization)
- Mid-cycle (coding, charging)
- Back-end (billing, collections)
- Payer performance
- Overall cycle time

### Reporting Standards
- Executive dashboards
- Operational reports
- Trend visualizations
- Drill-down analysis
- Action-oriented insights

## Integration Points

### Related Processes
- Claims Management Workflow
- Denial Prevention and Management
- Prior Authorization Workflow

### Collaborating Skills
- medical-coding-audit
- clinical-documentation-query
- payer-contract-analysis

## References

- HFMA revenue cycle metrics
- MGMA benchmarking data
- Industry best practices
- Payer performance standards
