---
name: scholarly-literature-synthesis
description: Survey, analyze, and synthesize philosophical literature on topics, identify major positions, trace debates, and locate gaps in scholarly discourse
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Scholarly Literature Synthesis Skill

Survey, analyze, and synthesize philosophical literature to identify positions, trace debates, and locate scholarly gaps.

## Overview

The Scholarly Literature Synthesis skill enables systematic survey, analysis, and synthesis of philosophical literature on topics, identification of major positions and their proponents, tracing of scholarly debates, and location of gaps in current discourse for research contribution.

## Capabilities

### Literature Survey
- Conduct comprehensive searches
- Identify key works and authors
- Track citation networks
- Access relevant databases
- Maintain currency

### Position Analysis
- Identify major positions
- Analyze supporting arguments
- Compare competing views
- Assess strengths and weaknesses
- Understand historical development

### Debate Tracing
- Map scholarly conversations
- Identify points of contention
- Track argument development
- Understand position evolution
- Locate current frontiers

### Gap Identification
- Recognize understudied areas
- Identify missing perspectives
- Spot methodological gaps
- Note empirical lacunae
- Propose research directions

### Synthesis Writing
- Organize literature coherently
- Present balanced summaries
- Connect disparate works
- Build narrative structure
- Support original contribution

## Usage Guidelines

### When to Use
- Beginning research projects
- Writing literature reviews
- Preparing dissertations
- Reviewing for journals
- Teaching graduate students

### Best Practices
- Search comprehensively
- Organize systematically
- Read critically
- Synthesize rather than summarize
- Update regularly

### Integration Points
- Philosophical Writing and Argumentation skill
- Argument Mapping and Reconstruction skill
- Hermeneutical Interpretation skill
- Comparative Religion Analysis skill

## References

- Philosophical Literature Review process
- Peer Review and Scholarly Critique process
- Conference Presentation Development process
- Academic Philosophy Writer Agent
- Hermeneutics Specialist Agent
