---
name: scipy-optimization-toolkit
description: SciPy scientific computing skill for numerical optimization, integration, and signal processing in physics
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: physics
  domain: science
  category: data-analysis
  phase: 6
---

# SciPy Optimization Toolkit

## Purpose

Provides expert guidance on SciPy for scientific computing in physics, including optimization, integration, and signal processing.

## Capabilities

- Nonlinear least squares fitting
- Global optimization methods
- Numerical integration (quadrature)
- ODE/PDE solvers
- Signal processing (FFT, filtering)
- Sparse matrix operations

## Usage Guidelines

1. **Optimization**: Use appropriate optimizer for the problem type
2. **Fitting**: Apply nonlinear least squares for data fitting
3. **Integration**: Choose proper quadrature methods
4. **ODEs**: Solve differential equations with adaptive solvers
5. **Signal Processing**: Apply FFT and filtering techniques

## Tools/Libraries

- SciPy
- NumPy
- lmfit
