---
name: screenplay-formatting
id: SK-FTV-011
version: 1.0.0
description: Format screenplays to industry standard using Fountain markup for professional presentation
specialization: film-tv-production
---

# Screenplay Formatting Skill

## Purpose

Format screenplays to industry standard specifications. Proper formatting demonstrates professionalism and ensures your script is taken seriously. One page equals approximately one minute of screen time.

## Fountain Format

Fountain is a plain text markup syntax for screenplays that exports to industry-standard PDF.

### Basic Elements

```fountain
Title:
    THE EXAMPLE SCREENPLAY
Credit: Written by
Author: Your Name
Draft date: January 2026
Contact:
    your@email.com
    123-456-7890

====

FADE IN:

INT. COFFEE SHOP - DAY

Description of the scene and setting goes here.

CHARACTER NAME
Dialogue goes here.

FADE OUT.

THE END
```

## Element Formatting

### Scene Headings (Sluglines)

```fountain
INT. LOCATION - TIME
EXT. LOCATION - TIME
INT./EXT. LOCATION - TIME
```

**Components:**
- `INT.` (interior) or `EXT.` (exterior)
- Location name in CAPS
- Time: DAY, NIGHT, CONTINUOUS, LATER, SAME, DAWN, DUSK

**Examples:**
```fountain
INT. JOHN'S APARTMENT - LIVING ROOM - NIGHT
EXT. CENTRAL PARK - CONTINUOUS
INT./EXT. MOVING CAR - DAY
```

### Action/Description

```fountain
Present tense. Active voice. Only what we see and hear.

Keep paragraphs short. Three to four lines maximum.

White space creates pace and readability.
```

**Rules:**
- Present tense always
- First appearance: CHARACTER NAME in CAPS
- Sounds in CAPS: BANG, CRASH
- No camera directions (usually)
- No internal thoughts
- 55-60 characters per line

### Character Names

```fountain
CHARACTER NAME
Dialogue here.

CHARACTER NAME (V.O.)
Voice over dialogue.

CHARACTER NAME (O.S.)
Off-screen dialogue.

CHARACTER NAME (CONT'D)
Continued from previous block.
```

### Dialogue

```fountain
CHARACTER
Regular dialogue goes here.

CHARACTER
(parenthetical)
Dialogue with direction.

CHARACTER
(beat)
Indicates a pause.
```

**Parentheticals:**
- Use sparingly
- For tone: `(sarcastically)`
- For direction: `(to John)`
- For action: `(standing)`
- NOT for every line
- NOT for obvious emotions

### Transitions

```fountain
CUT TO:

SMASH CUT TO:

DISSOLVE TO:

FADE TO BLACK.

FADE IN:

FADE OUT.
```

**Note:** Most scene changes are implied cuts. Use transitions sparingly.

### Special Elements

```fountain
> INTERCUT - LOCATION A/LOCATION B

FLASHBACK:

END FLASHBACK.

MONTAGE:

A) First image
B) Second image
C) Third image

END MONTAGE.

SUPER: "Three years later"

SERIES OF SHOTS:

A) Description
B) Description

END SERIES OF SHOTS.
```

## Page Layout Specifications

### Margins (Industry Standard)

```
Top margin:     1 inch
Bottom margin:  0.5-1 inch
Left margin:    1.5 inches
Right margin:   1 inch

Action:         Left margin at 1.5"
Character:      3.5" from left
Parenthetical:  3" from left
Dialogue:       2.5" from left, 2" wide
Transitions:    Right aligned
```

### Font and Spacing

```
Font:           Courier 12pt
Line spacing:   Single
Between elements: Single blank line
```

### Page Numbers

```
Page numbers top right
First page has no number
"1." or just "1" formats acceptable
```

## Format by Project Type

### Feature Film
- 90-120 pages typical
- Three-act structure
- No act breaks marked
- Scene numbers only for shooting scripts

### TV Pilot (One-Hour Drama)
- 55-65 pages
- Act breaks marked: `END OF ACT ONE`
- Teaser optional
- Cold open common

### TV Pilot (Half-Hour Comedy)
- 25-35 pages (single-cam)
- 40-50 pages (multi-cam, double-spaced dialogue)
- Act breaks marked
- Tags common

### Short Film
- 1-40 pages
- Same formatting rules
- Tighter, more economical

### Shooting Script Additions
- Scene numbers (both margins)
- Revision marks (`*` in margin)
- Colored pages for revisions
- Day breaks
- Page locks

## Common Formatting Mistakes

### Don't:
```
❌ We see John walk in (don't say "we see")
❌ JOHN walks in angrily (use action, not adverb)
❌ CAMERA PANS to reveal... (no camera directions)
❌ John thinks about his childhood (can't film thoughts)
❌ John (35, handsome, like Brad Pitt) (too specific casting)
```

### Do:
```
✓ John enters, shoulders slumped.
✓ JOHN, 30s, weary eyes that have seen too much.
✓ A photograph on the desk catches his attention.
✓ He picks it up. His jaw tightens.
```

## Fountain Quick Reference

```fountain
# Scene Heading forces a scene heading
.FORCED ACTION LINE (note the period)
@Character Name (forces character)
~Lyrics in dialogue
/*
Block comment
*/
[[ Note to self or reader ]]
= Section heading (for organization)
== Second level heading
```

## Title Page Template

```fountain
Title: YOUR TITLE HERE
Credit: Written by
Author: Your Name
Source: Based on the novel by Author Name
Draft date: January 27, 2026
Contact:
    Your Name
    your@email.com
    (555) 123-4567
    Agent Name, Agency
Copyright: (c) 2026 Your Name

====
```

## Quality Checklist

- [ ] Title page complete
- [ ] Scene headings consistent
- [ ] Character names capitalized on intro
- [ ] Parentheticals used sparingly
- [ ] Action in present tense
- [ ] Page count appropriate for format
- [ ] Proper Courier 12pt font
- [ ] Margins correct
- [ ] No camera directions (unless shooting script)
- [ ] No typos or grammatical errors
- [ ] Page breaks don't split dialogue
- [ ] Transitions used sparingly
