---
name: seismic-enablement
description: Seismic sales enablement platform for content and learning
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
  - WebFetch
metadata:
  specialization: sales
  domain: business
  priority: P1
  integration-points:
    - Seismic API
---

# Seismic Enablement

## Overview

The Seismic Enablement skill provides integration with Seismic's sales enablement platform for content recommendation, buyer engagement analytics, learning path management, and content performance tracking. This skill connects sales teams with the right content at the right time.

## Capabilities

### Content Recommendation
- Surface relevant content for deals
- Personalize recommendations by context
- Track content usage patterns
- Optimize content suggestions over time

### Buyer Engagement Analytics
- Track content viewing activity
- Measure engagement duration and depth
- Identify high-interest content
- Alert on buyer activity

### Learning Management
- Assign learning paths and modules
- Track completion and assessment scores
- Certify knowledge acquisition
- Reinforce with spaced repetition

### Content Performance
- Measure content effectiveness
- Track usage by role and segment
- Identify high-performing assets
- Optimize content investment

## Usage

### Content Discovery
```
Find and recommend the most relevant content for a specific deal stage and buyer persona.
```

### Engagement Analysis
```
Analyze buyer engagement with shared content to identify interested stakeholders and topics.
```

### Learning Assignment
```
Assign a learning path to new hires and track their progress through certification.
```

## Enhances Processes

- sales-playbook-development
- new-hire-onboarding-ramp
- competitive-battle-cards

## Dependencies

- Seismic subscription
- Content library population
- CRM integration
