---
name: semantic-scholar-search
description: Academic literature search using Semantic Scholar API for citation-aware paper discovery
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
  - WebFetch
  - WebSearch
metadata:
  specialization: scientific-discovery
  domain: science
  category: literature-knowledge
  phase: 6
---

# Semantic Scholar Search

## Purpose

Provides academic literature search capabilities using the Semantic Scholar API for citation-aware paper discovery and research trend identification.

## Capabilities

- Keyword and semantic search across papers
- Citation network analysis
- Author influence scoring
- Research trend identification
- Paper recommendation based on reading history
- TLDR summary extraction

## Usage Guidelines

1. **Search Strategy**: Combine keywords with semantic similarity
2. **Citation Analysis**: Build citation networks for key papers
3. **Author Analysis**: Identify influential researchers
4. **Trend Detection**: Track emerging research areas

## Tools/Libraries

- Semantic Scholar API
- NetworkX
- sentence-transformers
