# Serialization Skill

Expert skill for binary and text serialization formats, schema design, and optimization.

## Overview

This skill provides specialized capabilities for working with binary serialization formats including Protocol Buffers, FlatBuffers, MessagePack, and CBOR. It covers schema design, code generation, and performance optimization.

## Key Features

- Protocol Buffers schema design and codegen
- FlatBuffers zero-copy serialization
- MessagePack/CBOR binary encoding
- Performance analysis and comparison
- Schema evolution and compatibility

## When to Use

- Designing efficient wire formats
- Implementing binary protocols
- Optimizing payload sizes
- Comparing serialization options
- Handling schema migrations

## Dependencies

- protoc
- flatc
- msgpack-tools
- cbor-tools
- avro-tools
