# Service Mesh Skill

Service mesh configuration and operations expertise for Istio, Linkerd, and Consul Connect.

## ID
SK-009

## Category
Networking

## Quick Reference

| Aspect | Details |
|--------|---------|
| Slug | `service-mesh` |
| Primary Use | Service mesh installation, configuration, and operations |
| Dependencies | istioctl/linkerd/consul CLI, kubectl |
| Process Integration | service-mesh.js, kubernetes-setup.js |

## Key Capabilities

- **Istio Configuration**: VirtualService, DestinationRule, Gateway
- **Linkerd Operations**: ServiceProfile, TrafficSplit
- **Traffic Management**: Routing, retries, circuit breakers
- **Security**: mTLS, authorization policies, zero-trust
- **Observability**: Distributed tracing, metrics integration

## When to Use

Use this skill when you need to:
- Install and configure a service mesh
- Implement advanced traffic management
- Set up service-to-service security (mTLS)
- Debug mesh connectivity issues
- Integrate mesh observability

## Related

- **Skills**: kubernetes-ops (SK-001), prometheus-grafana (SK-003)
- **Agents**: kubernetes-expert (AG-001), secops-expert (AG-004)
