---
name: shader-optimization
description: Shader performance optimization skill for instruction counting, GPU profiling, and rendering efficiency.
allowed-tools: Read, Grep, Write, Bash, Edit, Glob, WebFetch
---

# Shader Optimization Skill

Shader performance optimization techniques.

## Overview

This skill provides capabilities for optimizing shader performance.

## Capabilities

- Instruction counting
- ALU optimization
- Texture sample reduction
- Shader variant management
- GPU profiling

## Best Practices

1. Minimize texture samples
2. Use half precision where possible
3. Avoid branching
4. Batch similar shaders
5. Profile on target hardware

## References

- Engine-specific profiling tools
