---
name: shot-composition
id: SK-FTV-009
version: 1.0.0
description: Plan camera angles, movements, shot sizes, and visual design for cinematic storytelling
specialization: film-tv-production
---

# Shot Composition Skill

## Purpose

Design visually compelling shots that serve the story. Every camera choice—angle, movement, lens, composition—should enhance meaning, create emotion, and guide the viewer's attention.

## Shot Sizes

### The Size Spectrum

```
EWS ─── WS ─── MWS ─── MS ─── MCU ─── CU ─── ECU
│       │       │       │       │       │      │
│       │       │       │       │       │      └── Detail/Eyes
│       │       │       │       │       └──────── Face
│       │       │       │       └──────────────── Head/Shoulders
│       │       │       └──────────────────────── Waist Up
│       │       └──────────────────────────────── Knees Up
│       └──────────────────────────────────────── Full Body
└──────────────────────────────────────────────── Environment
```

### When to Use Each

| Size | Use For | Emotion |
|------|---------|---------|
| EWS | Establishing, scope, isolation | Awe, loneliness |
| WS | Context, geography, action | Objective, neutral |
| MWS | Blocking, movement | Balance |
| MS | Conversation, action | Engagement |
| MCU | Emotion, dialogue | Connection |
| CU | Reaction, intimacy | Intensity |
| ECU | Detail, revelation | Impact |

## Camera Angles

### Vertical Angles

```
Bird's Eye   → Looking straight down (god view)
High Angle   → Looking down at subject (vulnerability)
Eye Level    → Neutral, natural (equality)
Low Angle    → Looking up at subject (power)
Worm's Eye   → Looking straight up (extreme power)
```

### Horizontal Angles

```
Frontal      → Direct, confrontational
3/4 Profile  → Most common, dimensional
Profile      → Reflective, contemplative
Over Shoulder → POV, conversation
Dutch Angle  → Unease, disorientation
```

## Camera Movement

### Movement Types

| Movement | Description | Effect |
|----------|-------------|--------|
| Static | No movement | Stability, observation |
| Pan | Horizontal pivot | Survey, follow |
| Tilt | Vertical pivot | Reveal, scale |
| Dolly | Camera moves forward/back | Intimacy, revelation |
| Track | Camera moves alongside | Follow, accompany |
| Crane | Camera moves up/down | Scope, grandeur |
| Steadicam | Smooth handheld | Immersion |
| Handheld | Naturalistic shake | Urgency, documentary |
| Zoom | Lens change (not movement) | Emphasis, isolation |

### Motivated Movement

Movement should be motivated by:
- Character movement (following action)
- Emotional revelation (moving in for intimacy)
- Story information (revealing new element)
- Point of view (showing what character sees)

## Composition Principles

### Rule of Thirds
```
┌───┬───┬───┐
│ • │   │ • │   Place subjects at intersections
├───┼───┼───┤   for dynamic composition
│   │ ○ │   │
├───┼───┼───┤   Center for stability/confrontation
│ • │   │ • │
└───┴───┴───┘
```

### Leading Lines
```
Lines that guide the eye:
- Roads, hallways, fences
- Arms, gaze direction
- Light beams, shadows
- Architectural elements
```

### Frame Within Frame
```
Use doorways, windows, mirrors
to create visual interest and
focus attention on subject
```

### Depth
```
Foreground  │  Midground  │  Background
    ↓              ↓             ↓
   Frame       Subject       Context
```

## Lens Choices

### Focal Length Effects

| Lens | Effect | Use |
|------|--------|-----|
| Wide (14-35mm) | Distortion, space | Environments, unease |
| Normal (35-50mm) | Natural | Dialogue, general |
| Telephoto (85mm+) | Compression, isolation | Portraits, tension |

### Depth of Field

```
Shallow DOF (f/1.4-2.8):
- Subject sharp, background blur
- Isolation, intimacy
- Focus pull for attention

Deep DOF (f/8-16):
- Everything in focus
- Context, geography
- Multiple planes of action
```

## Shot List Format

```markdown
## Scene [Number] Shot List

| Shot | Size | Angle | Lens | Movement | Subject | Action | Duration |
|------|------|-------|------|----------|---------|--------|----------|
| 1.1  | WS   | Eye   | 35mm | Static   | Room    | Est.   | 3s       |
| 1.2  | MS   | 3/4   | 50mm | Track    | Sarah   | Enter  | 5s       |
| 1.3  | CU   | Eye   | 85mm | Static   | Sarah   | React  | 2s       |
```

## Visual Storytelling

### Show Power Dynamics
```
DOMINANT: Low angle, higher position, larger frame
SUBMISSIVE: High angle, lower position, smaller frame
EQUAL: Eye level, similar frame sizes
```

### Create Tension
```
- Tight framing (claustrophobic)
- Negative space (anticipation)
- Off-center subjects (unease)
- Shallow DOF (isolation)
```

### Guide Emotion
```
JOY: Bright, warm, open framing
FEAR: Dark, tight, unpredictable
LOVE: Soft, close, warm tones
ANGER: Hard, dynamic, extreme angles
```

## Coverage Strategy

### Basic Scene Coverage
1. **Master** - Full scene in one shot
2. **Singles** - Individual close-ups
3. **Over-shoulders** - Conversation coverage
4. **Inserts** - Detail shots
5. **Cutaways** - Reaction, environment

### Action Coverage
1. **Wide master** - Geography
2. **Medium action** - Key moments
3. **Close details** - Impact
4. **Reaction** - Emotional response

## Shot Breakdown Template

```markdown
## Shot [ID]

### Technical
- **Size:** [EWS/WS/MS/MCU/CU/ECU]
- **Angle:** [Eye/Low/High/Dutch]
- **Lens:** [Focal length]
- **Movement:** [Type and direction]
- **Duration:** [Seconds]

### Composition
- **Subject Placement:** [Thirds/Center]
- **Depth:** [FG/MG/BG elements]
- **Leading Lines:** [If any]

### Purpose
- **Story Function:** [What it communicates]
- **Emotional Intent:** [What viewer should feel]

### AI Video Prompt
[Optimized prompt for generation]
```

## Quality Checklist

- [ ] Shot size serves scene purpose
- [ ] Angle reinforces power/emotion
- [ ] Movement is motivated
- [ ] Composition guides eye
- [ ] Coverage is complete
- [ ] Continuity maintained
- [ ] Screen direction consistent
- [ ] Each shot earns its place
