---
name: socratic-dialogue-facilitation
description: Lead philosophical inquiry through structured questioning, elicit assumptions, expose contradictions, and guide interlocutors toward deeper understanding
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Socratic Dialogue Facilitation Skill

Lead philosophical inquiry through structured questioning to elicit assumptions and guide deeper understanding.

## Overview

The Socratic Dialogue Facilitation skill enables leading philosophical inquiry through structured questioning, eliciting and examining assumptions, exposing contradictions and inconsistencies, and guiding interlocutors toward deeper understanding through collaborative inquiry.

## Capabilities

### Question Design
- Craft probing questions
- Sequence questions effectively
- Adapt to responses
- Target assumptions
- Promote reflection

### Assumption Elicitation
- Surface implicit beliefs
- Identify presuppositions
- Examine foundational claims
- Question common sense
- Reveal hidden commitments

### Contradiction Exposure
- Identify inconsistencies
- Highlight tensions
- Pursue implications
- Maintain constructive tone
- Guide toward resolution

### Dialogue Management
- Facilitate productive exchange
- Maintain focus
- Balance participation
- Handle disagreement
- Build understanding

### Pedagogical Application
- Design learning experiences
- Assess understanding
- Develop critical thinking
- Support student inquiry
- Model philosophical method

## Usage Guidelines

### When to Use
- Teaching philosophy
- Leading discussions
- Facilitating deliberation
- Conducting tutorials
- Developing critical thinking

### Best Practices
- Question genuinely
- Listen carefully
- Respect interlocutors
- Maintain humility
- Pursue truth collaboratively

### Integration Points
- Fallacy Detection and Analysis skill
- Ethical Framework Application skill
- Argument Mapping and Reconstruction skill
- Conceptual Analysis skill

## References

- Critical Thinking Assessment process
- Ethical Theory Comparison process
- Applied Ethics Case Analysis process
- Critical Thinking Educator Agent
- Ethics Consultant Agent
