---
name: sox-control-tester
description: SOX Section 404 control testing skill with workpaper generation and deficiency classification
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
metadata:
  specialization: finance-accounting
  domain: business
  category: audit
  priority: medium
---

# SOX Control Tester

## Overview

The SOX Control Tester skill provides comprehensive Sarbanes-Oxley Section 404 control testing capabilities. It supports control documentation, testing execution, and deficiency evaluation for internal control over financial reporting.

## Capabilities

### Control Walkthrough Documentation
- Process narrative creation
- Control point identification
- Risk and control mapping
- Information flow documentation
- Personnel interviews
- System touchpoint identification

### Sample Selection Methodology
- Population definition
- Sample size determination
- Random selection procedures
- Stratified sampling
- Judgmental sampling rationale
- Documentation requirements

### Test of Design Effectiveness
- Control design evaluation
- Preventive vs. detective analysis
- Key control identification
- Compensating control assessment
- Design gap identification
- Remediation recommendation

### Test of Operating Effectiveness
- Test procedure execution
- Evidence collection
- Attribute testing
- Exception documentation
- Reperformance procedures
- Inquiry corroboration

### Deficiency Evaluation
- Control deficiency identification
- Severity assessment criteria
- Compensating control consideration
- Significant deficiency determination
- Material weakness classification
- Aggregation analysis

### Remediation Tracking
- Remediation plan documentation
- Milestone tracking
- Responsible party assignment
- Evidence collection
- Validation testing
- Closure documentation

## Usage

### Control Testing Cycle
```
Input: Control inventory, risk assessment, testing plan
Process: Execute walkthroughs and tests, evaluate results
Output: Testing workpapers, deficiency report, remediation tracking
```

### Deficiency Assessment
```
Input: Identified exceptions, control population, financial impact
Process: Evaluate severity, consider compensating controls
Output: Deficiency classification, management action plan
```

## Integration

### Used By Processes
- SOX Compliance and Testing
- Internal Audit Planning and Execution
- External Audit Coordination

### Tools and Libraries
- GRC platforms (Workiva, AuditBoard)
- Control libraries
- Testing templates

## Best Practices

1. Maintain current risk and control matrices
2. Document all testing procedures and results
3. Evaluate deficiencies promptly
4. Coordinate with external auditors
5. Track remediation to completion
6. Update control documentation for changes
