---
name: stakeholder-facilitation
description: Facilitate meetings, workshops, and community consultations with diverse stakeholders including artists, board members, funders, and community representatives
allowed-tools: Read, Grep, Write, Edit, Glob
---

# Stakeholder Facilitation

Facilitate meetings, workshops, and community consultations with diverse stakeholders including artists, board members, funders, and community representatives.

## Overview

This skill enables effective facilitation of stakeholder engagement processes for cultural organizations. It encompasses meeting design, workshop facilitation, community consultation, and consensus building to achieve organizational and community goals.

## Capabilities

### Meeting Design
- Plan meeting agendas and objectives
- Select appropriate facilitation methods
- Prepare materials and logistics
- Anticipate group dynamics
- Design for inclusive participation

### Workshop Facilitation
- Lead strategic planning sessions
- Facilitate creative brainstorming
- Manage group decision-making
- Navigate conflict constructively
- Document outcomes effectively

### Community Consultation
- Design community engagement processes
- Reach diverse stakeholder groups
- Create safe spaces for dialogue
- Gather and synthesize input
- Report back to communities

### Consensus Building
- Identify common ground
- Navigate competing interests
- Build coalitions and support
- Mediate disagreements
- Document agreements and commitments

## Usage Guidelines

### Facilitation Process
1. Clarify purpose and objectives
2. Identify and invite stakeholders
3. Design participatory process
4. Prepare materials and logistics
5. Facilitate sessions effectively
6. Document and follow up

### Inclusive Practices
- Ensure diverse representation
- Use accessible venues and methods
- Provide accommodations as needed
- Create welcoming environments
- Value all contributions

### Documentation Standards
- Record meeting notes and decisions
- Capture diverse perspectives
- Document action items and responsibilities
- Share summaries with participants
- Archive for organizational memory

## Integration Points

### Related Processes
- Strategic Planning Process
- Cultural Planning Process
- Community Engagement Process
- Board Governance Process

### Collaborating Skills
- cultural-policy-analysis
- arts-advocacy-communication
- donor-relationship-management

## References

- IAP2 Public Participation Spectrum
- Facilitation best practices
- Community engagement standards
- Consensus decision-making models
