---
name: standards-alignment-mapping
description: Systematically map curriculum content to educational standards with vertical and horizontal alignment documentation
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Standards Alignment Mapping

Systematically map curriculum content to educational standards with vertical and horizontal alignment documentation.

## Overview

This skill enables systematic alignment of curriculum to educational standards. It encompasses mapping procedures, vertical and horizontal alignment, gap analysis, and documentation to ensure comprehensive standards coverage across educational programs.

## Capabilities

### Standards Analysis
- Interpret standards documents
- Unpack standards into components
- Identify prerequisite knowledge
- Map standards progressions
- Analyze standards relationships

### Alignment Mapping
- Map content to standards
- Document alignment evidence
- Assess alignment strength
- Identify multiple alignments
- Create alignment matrices

### Vertical Alignment
- Map progressions across grades
- Identify prerequisite relationships
- Ensure scaffolded development
- Document learning trajectories
- Address transition points

### Horizontal Alignment
- Coordinate across subjects
- Identify cross-curricular connections
- Plan interdisciplinary units
- Ensure consistent coverage
- Document relationships

## Usage Guidelines

### Alignment Process
1. Obtain and analyze standards
2. Unpack standards into learning targets
3. Map curriculum to standards
4. Assess alignment quality
5. Identify gaps and redundancies
6. Document and report

### Mapping Criteria
- Clear evidence of alignment
- Appropriate depth of coverage
- Cognitive level match
- Context appropriateness
- Assessment alignment

### Documentation Standards
- Create alignment matrices
- Document evidence rationale
- Note partial alignments
- Flag gaps for attention
- Maintain version control

## Integration Points

### Related Processes
- Standards-Based Curriculum Alignment
- Curriculum Mapping
- Scope and Sequence Planning

### Collaborating Skills
- learning-objectives-writing
- curriculum-gap-analysis
- assessment-item-development

## References

- Common Core State Standards
- NGSS Framework
- State standards documents
- Webb's Depth of Knowledge
