---
name: statistical-reporting-formatter
description: Skill for formatting statistical results according to reporting standards
allowed-tools:
  - Bash
  - Read
  - Write
metadata:
  specialization: scientific-discovery
  domain: science
  category: Communication
  skill-id: SK-SCIDISC-029
---

# Statistical Reporting Formatter Skill

## Purpose

Format statistical results according to APA, journal, and discipline-specific reporting standards for publication.

## Capabilities

- Format test results
- Apply APA style
- Generate tables
- Report effect sizes
- Include confidence intervals
- Check completeness

## Usage Guidelines

1. Input statistical output
2. Select reporting standard
3. Format results
4. Generate tables
5. Review completeness
6. Export formatted text

## Process Integration

Works within scientific discovery workflows for:
- Results reporting
- Manuscript preparation
- Table generation
- Compliance checking

## Configuration

- Reporting standards
- Decimal precision
- Table formats
- Output styles

## Output Artifacts

- Formatted statistics
- Publication tables
- In-text citations
- Compliance reports
