---
name: survey-design-administration
description: Develop survey instruments, implement sampling strategies, optimize response rates, and manage multi-mode data collection
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Survey Design and Administration Skill

Develop survey instruments, implement sampling strategies, and manage data collection for population-based research.

## Overview

The Survey Design and Administration skill enables development of survey instruments, implementation of sampling strategies, optimization of response rates, and management of multi-mode data collection for rigorous population-based social science research.

## Capabilities

### Questionnaire Design
- Question construction
- Response scale design
- Question ordering
- Skip logic implementation
- Cognitive testing

### Sampling Methods
- Probability sampling
- Stratified sampling
- Cluster sampling
- Multi-stage sampling
- Non-probability alternatives

### Response Optimization
- Contact strategies
- Incentive design
- Follow-up procedures
- Non-response analysis
- Weighting adjustments

### Multi-Mode Administration
- Web survey design
- Phone survey protocols
- Mail survey procedures
- Mixed-mode strategies
- Mode effect assessment

### Quality Control
- Data cleaning
- Response validation
- Item non-response handling
- Bias assessment
- Documentation standards

## Usage Guidelines

### When to Use
- Collecting population data
- Measuring attitudes/behaviors
- Conducting needs assessments
- Evaluating programs
- Testing hypotheses

### Best Practices
- Pilot test instruments
- Document procedures
- Monitor response rates
- Address non-response
- Archive data properly

### Integration Points
- Psychometric Assessment skill
- Quantitative Methods skill
- Research Ethics and IRB skill
- Mixed Methods Integration skill

## References

- Survey Research Design process
- Survey Administration process
- Scale Development and Validation process
- Survey Research Director agent
