# SVA Assertions Skill

Specialized skill for creating and debugging SystemVerilog Assertions (SVA) for FPGA verification.

## Purpose

This skill provides deep expertise in SVA development, enabling:
- Formal property specification
- Temporal property verification
- Functional coverage through cover properties
- Formal verification constraint development

## Key Features

- Concurrent and immediate assertion creation
- Property and sequence specification
- Assertion bind file generation
- Formal tool integration
- Performance-optimized assertion coding

## Integration

Used primarily with:
- SVA Development Process
- Constrained Random Verification Process
- UVM Testbench Process
- Verilog/SystemVerilog Design Process

## Related

- SK-003 in skills-agents-backlog.md
- Verification Expert Agent (AG-003)
