---
name: synthesis-specification-language
description: Define specifications for program synthesis using various paradigms
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: computer-science
  domain: science
  category: program-synthesis
  phase: 6
---

# Synthesis Specification Language

## Purpose

Provides expert guidance on defining specifications for program synthesis using examples, logic, or sketches.

## Capabilities

- Input-output example specification
- Logical specification (pre/post conditions)
- Sketch-based specification
- Natural language to specification
- Specification validation
- Ambiguity detection

## Usage Guidelines

1. **Paradigm Selection**: Choose specification paradigm
2. **Specification Writing**: Write formal specification
3. **Validation**: Validate specification for completeness
4. **Disambiguation**: Resolve specification ambiguities
5. **Integration**: Connect to synthesis engines

## Tools/Libraries

- SyGuS format
- Sketch
- Rosette
- FlashFill
