---
name: systematic-review
description: Conduct comprehensive literature searches, quality assessments, evidence synthesis, and meta-analyses
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Systematic Review Skill

Conduct comprehensive literature searches, quality assessments, and evidence synthesis including meta-analysis.

## Overview

The Systematic Review skill enables conducting comprehensive literature searches, quality assessments, evidence synthesis, and meta-analyses following established protocols for rigorous evidence-based research and policy making.

## Capabilities

### Search Strategy
- Database selection
- Search term development
- Boolean operators
- Citation tracking
- Grey literature inclusion

### Study Selection
- Inclusion/exclusion criteria
- Screening procedures
- Dual review process
- Disagreement resolution
- PRISMA documentation

### Quality Assessment
- Risk of bias tools
- Quality checklists
- Evidence grading
- Study appraisal
- Bias identification

### Evidence Synthesis
- Narrative synthesis
- Vote counting
- Framework synthesis
- Thematic synthesis
- Realist synthesis

### Meta-Analysis
- Effect size calculation
- Heterogeneity assessment
- Fixed/random effects
- Publication bias
- Sensitivity analysis

## Usage Guidelines

### When to Use
- Synthesizing evidence
- Informing policy
- Identifying research gaps
- Establishing consensus
- Supporting decisions

### Best Practices
- Register protocol
- Document thoroughly
- Use multiple reviewers
- Assess bias
- Update regularly

### Integration Points
- Quantitative Methods skill
- Qualitative Analysis skill
- Policy Communication skill
- Academic Writing and Publication skill

## References

- Literature Review and Synthesis process
- Policy Impact Assessment process
- Policy Research Analyst agent
- Mixed Methods Research Coordinator agent
