---
name: systems-dynamics-modeler
description: Skill for building and simulating systems dynamics models
allowed-tools:
  - Bash
  - Read
  - Write
metadata:
  specialization: scientific-discovery
  domain: science
  category: Hypothesis Development
  skill-id: SK-SCIDISC-012
---

# Systems Dynamics Modeler Skill

## Purpose

Build and simulate systems dynamics models to understand complex system behavior, feedback loops, and emergent phenomena.

## Capabilities

- Build stock-flow diagrams
- Model feedback loops
- Simulate system behavior
- Analyze equilibria
- Perform sensitivity analysis
- Generate scenarios

## Usage Guidelines

1. Define system boundaries
2. Identify stocks and flows
3. Model feedback loops
4. Parameterize model
5. Run simulations
6. Analyze results

## Process Integration

Works within scientific discovery workflows for:
- Complex systems analysis
- Policy modeling
- Scenario planning
- Behavior prediction

## Configuration

- Model parameters
- Simulation settings
- Visualization options
- Output formats

## Output Artifacts

- System diagrams
- Simulation results
- Scenario analyses
- Behavior reports
