---
name: tech-stack-scanner
description: Automated technical architecture review, security assessment, scalability analysis
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
  - WebFetch
metadata:
  specialization: venture-capital
  domain: business
  skill-id: vc-skill-013
---

# Tech Stack Scanner

## Overview

The Tech Stack Scanner skill provides automated technical architecture review for venture capital due diligence. It assesses technology choices, infrastructure scalability, security posture, and technical debt to inform investment decisions.

## Capabilities

### Architecture Assessment
- Evaluate technology stack choices
- Assess microservices vs. monolith architecture
- Review database and data store choices
- Analyze API design and integration patterns

### Infrastructure Review
- Evaluate cloud infrastructure (AWS, GCP, Azure)
- Assess scalability and auto-scaling capabilities
- Review disaster recovery and backup strategies
- Analyze infrastructure costs and efficiency

### Security Assessment
- Review authentication and authorization
- Assess data encryption practices
- Check for common vulnerabilities
- Evaluate security monitoring and incident response

### Scalability Analysis
- Model load handling capabilities
- Identify potential bottlenecks
- Assess horizontal vs. vertical scaling
- Review performance optimization practices

## Usage

### Scan Tech Stack
```
Input: Company technical documentation, access credentials
Process: Automated scanning, architecture analysis
Output: Tech stack assessment, architecture diagram
```

### Assess Security Posture
```
Input: Security policies, system access
Process: Security scanning, policy review
Output: Security assessment, vulnerability report
```

### Evaluate Scalability
```
Input: Current load, growth projections, infrastructure
Process: Load modeling, bottleneck analysis
Output: Scalability assessment, recommendations
```

### Review Infrastructure Costs
```
Input: Cloud billing data, infrastructure inventory
Process: Cost analysis, optimization identification
Output: Cost assessment, efficiency recommendations
```

## Assessment Categories

| Category | Key Areas |
|----------|-----------|
| Architecture | Stack choices, patterns, technical debt |
| Infrastructure | Cloud, scaling, DR, monitoring |
| Security | Auth, encryption, vulnerabilities, compliance |
| Performance | Response times, throughput, optimization |
| DevOps | CI/CD, deployment, testing, monitoring |

## Integration Points

- **Technical Due Diligence**: Core skill for tech DD
- **Code Quality Analyzer**: Detailed code-level analysis
- **IP Patent Analyzer**: Coordinate IP and tech review
- **Technical Assessor (Agent)**: Support DD agent

## Technology Checklist

- Frontend frameworks and mobile platforms
- Backend languages and frameworks
- Databases and data storage
- Cloud infrastructure and services
- Third-party integrations and dependencies
- Development and deployment tools
- Monitoring and observability

## Best Practices

1. Request architecture documentation upfront
2. Supplement automated scanning with interviews
3. Focus on scalability relative to growth plans
4. Assess technical debt pragmatically
5. Consider technology choices in industry context
