---
name: tei-text-encoding
description: Encode texts following Text Encoding Initiative standards for digital editions, annotations, and scholarly apparatus
allowed-tools: Read, Grep, Write, Edit, Glob, Bash
---

# TEI Text Encoding

Encode texts following Text Encoding Initiative standards for digital editions, annotations, and scholarly apparatus.

## Overview

This skill enables encoding of texts using TEI XML standards. It encompasses document structure markup, scholarly annotation, critical apparatus encoding, and metadata documentation for digital humanities projects.

## Capabilities

### Document Structure
- Header encoding
- Text division marking
- Paragraph and line elements
- List and table encoding
- Figure and graphic references

### Scholarly Annotation
- Editorial interventions
- Commentary notes
- Cross-references
- Index entries
- Bibliography links

### Critical Apparatus
- Variant readings
- Witness documentation
- Apparatus entries
- Textual notes
- Stemmatic information

### Metadata
- TEI header completion
- Source description
- Encoding description
- Profile description
- Revision history

## Usage Guidelines

### Encoding Process
1. Analyze source document
2. Plan encoding strategy
3. Create TEI header
4. Encode document structure
5. Add scholarly annotations
6. Validate against schema
7. Document conventions

### TEI Best Practices
- Follow TEI Guidelines
- Use appropriate modules
- Maintain consistency
- Document customizations
- Validate regularly

### Quality Standards
- Schema compliance
- Encoding completeness
- Documentation clarity
- Reproducibility
- Sustainability

## Integration Points

### Related Processes
- Digital Archive Development
- Textual Criticism and Editing
- Text Mining and Distant Reading

### Collaborating Skills
- metadata-standards-implementation
- literary-close-reading
- archival-finding-aid-interpretation

## References

- TEI Guidelines
- TEI by Example tutorials
- Digital editing standards
- XML best practices
