---
name: tensorflow-physics-ml
description: TensorFlow machine learning skill specialized for physics applications including neural network potentials and surrogate models
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: physics
  domain: science
  category: data-analysis
  phase: 6
---

# TensorFlow Physics ML

## Purpose

Provides expert guidance on TensorFlow for physics applications, including physics-informed neural networks and neural network potentials.

## Capabilities

- Physics-informed neural networks (PINNs)
- Neural network potentials (NNP)
- Normalizing flows for density estimation
- Graph neural networks for molecular systems
- Automatic differentiation for physics
- TensorBoard experiment tracking

## Usage Guidelines

1. **Architecture Design**: Build appropriate neural network architectures
2. **PINNs**: Incorporate physical constraints in loss functions
3. **Potentials**: Train neural network interatomic potentials
4. **GNNs**: Use graph networks for molecular systems
5. **Training**: Monitor and optimize training with TensorBoard

## Tools/Libraries

- TensorFlow
- DeepMD-kit
- SchNet
