# Textual Scaffolder Skill

Generate Textual TUI applications in Python with CSS styling and modern async patterns.

## Overview

This skill scaffolds terminal UI applications using Textual, the modern Python TUI framework with CSS-based styling, reactive attributes, and async support.

## When to Use

- Building terminal UIs in Python
- Creating CSS-styled terminal interfaces
- Implementing multi-screen applications
- Setting up Textual projects

## Quick Start

```json
{
  "projectName": "my-tui",
  "screens": ["main", "settings", "help"],
  "widgets": ["status_bar", "sidebar"]
}
```

## Features

- CSS-based styling
- Reactive attributes
- Screen management
- Custom widgets
- Data tables and forms

## Integration with Processes

| Process | Integration |
|---------|-------------|
| tui-application-framework | Python TUI setup |
| interactive-form-implementation | Form widgets |
| dashboard-monitoring-tui | Display components |
