---
name: theorem-prover-interface
description: Interface with interactive theorem provers for mechanized verification
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: computer-science
  domain: science
  category: formal-verification
  phase: 6
---

# Theorem Prover Interface

## Purpose

Provides expert guidance on using interactive theorem provers for mechanized formal verification.

## Capabilities

- Coq proof script generation
- Isabelle/HOL interface
- Lean 4 integration
- Proof automation (hammers, tactics)
- Proof library search
- Extraction to executable code

## Usage Guidelines

1. **Prover Selection**: Choose appropriate theorem prover
2. **Formalization**: Formalize definitions and theorems
3. **Proof Development**: Develop proofs interactively
4. **Automation**: Apply automated tactics
5. **Extraction**: Extract certified code if needed

## Tools/Libraries

- Coq
- Isabelle
- Lean
- ACL2
