---
name: thought-experiment-design
description: Construct, analyze, and evaluate philosophical thought experiments to test intuitions, reveal conceptual commitments, and probe theoretical implications
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Thought Experiment Design Skill

Construct and analyze philosophical thought experiments to test intuitions and explore theoretical implications.

## Overview

The Thought Experiment Design skill enables construction, analysis, and evaluation of philosophical thought experiments to test moral and metaphysical intuitions, reveal conceptual commitments, probe theoretical implications, and advance philosophical understanding.

## Capabilities

### Thought Experiment Construction
- Design clear experimental scenarios
- Control relevant variables
- Isolate target features
- Ensure internal consistency
- Maintain philosophical relevance

### Intuition Elicitation
- Identify target intuitions
- Frame scenarios effectively
- Minimize confounding factors
- Test intuitions systematically
- Document intuitive responses

### Conceptual Probing
- Reveal hidden commitments
- Test conceptual boundaries
- Explore edge cases
- Identify inconsistencies
- Clarify conceptual content

### Theoretical Testing
- Derive experimental predictions
- Test theoretical implications
- Compare competing theories
- Assess explanatory power
- Evaluate theoretical adequacy

### Critical Evaluation
- Assess thought experiment validity
- Identify potential confounds
- Evaluate intuition reliability
- Consider alternative interpretations
- Analyze philosophical significance

## Usage Guidelines

### When to Use
- Testing philosophical theories
- Exploring conceptual commitments
- Teaching philosophical methods
- Advancing debates
- Developing original philosophy

### Best Practices
- Keep scenarios minimal and focused
- Avoid misleading framing
- Consider multiple variants
- Test for intuition stability
- Engage with existing literature

### Integration Points
- Conceptual Analysis skill
- Ethical Framework Application skill
- Evidence and Justification Assessment skill
- Philosophical Writing and Argumentation skill

## References

- Thought Experiment Development process
- Ontological Analysis process
- Skeptical Challenge Analysis process
- Metaphysics and Epistemology Agent
- Academic Philosophy Writer Agent
