---
name: trade-study
description: Structured skill for conducting engineering trade studies
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
  - WebFetch
  - WebSearch
  - Bash
metadata:
  version: "1.0"
  category: aerospace-engineering
  tags:
    - systems-engineering
    - trade-study
    - decision-analysis
    - optimization
---

# Trade Study Methodology Skill

## Purpose
Enable structured engineering trade studies for design decisions including criteria definition, alternatives evaluation, and sensitivity analysis.

## Capabilities
- Trade study framework setup
- Weighted criteria definition
- Alternatives generation support
- Quantitative scoring methods
- Sensitivity analysis execution
- Pugh matrix implementation
- Decision documentation
- Stakeholder input integration

## Usage Guidelines
- Define clear objectives and constraints before starting trade study
- Involve stakeholders in criteria weighting
- Generate diverse alternatives to explore solution space
- Use consistent scoring methodology across alternatives
- Perform sensitivity analysis on key parameters
- Document rationale and assumptions for decision record

## Dependencies
- Decision analysis tools
- Spreadsheets
- Requirements management integration

## Process Integration
- AE-020: Trade Study Methodology
