---
name: training-curriculum-designer
description: Design training curricula and learning paths for change initiatives with competency-based learning
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
metadata:
  specialization: business-analysis
  domain: business
  id: SK-015
  category: Learning & Development
---

# Training Curriculum Designer

## Overview

The Training Curriculum Designer skill provides specialized capabilities for designing comprehensive training curricula and learning paths. This skill enables competency-based learning design, learning objective development using Bloom's taxonomy, and complete training program planning for change initiatives and capability building.

## Capabilities

### Competency-Based Learning Paths
- Create competency-based learning paths
- Map competencies to learning objectives
- Define proficiency levels
- Design progression sequences

### Learning Objectives Development
- Generate learning objectives using Bloom's taxonomy
- Create measurable outcome statements
- Align objectives with business goals
- Structure objectives by cognitive level

### Training Module Outlines
- Create detailed training module outlines
- Define content sections and activities
- Specify duration and delivery method
- Include practice and assessment components

### Assessment Instrument Design
- Design assessment instruments
- Create pre/post knowledge assessments
- Develop skills demonstrations
- Build competency verification tools

### Training Effort Calculation
- Calculate training effort and duration
- Estimate development time
- Plan delivery resources
- Budget training costs

### Blended Learning Strategies
- Create blended learning strategies
- Mix synchronous and asynchronous
- Combine digital and in-person
- Design reinforcement activities

### Training Schedule and Logistics
- Generate training schedules
- Plan venue and resource requirements
- Coordinate facilitator assignments
- Manage participant enrollment

## Usage

### Create Learning Path
```
Create a competency-based learning path for:
Role: [Target role]
Competencies Required: [Competency list]

Design progression from novice to proficient.
```

### Develop Learning Objectives
```
Develop learning objectives for this training:
[Training topic description]

Apply Bloom's taxonomy and ensure measurability.
```

### Design Training Module
```
Design a training module for:
Topic: [Topic]
Duration: [Available time]
Audience: [Target audience]

Include content outline, activities, and assessments.
```

### Plan Training Program
```
Plan a complete training program for:
Change Initiative: [Description]
Target Audience: [Roles and count]

Include curriculum, schedule, and logistics.
```

## Process Integration

This skill integrates with the following business analysis processes:
- training-enablement-design.js - Core training design
- knowledge-transfer.js - Capability building programs
- change-management-strategy.js - Change training components

## Dependencies

- Learning design templates
- Bloom's taxonomy framework
- Training planning tools
- Assessment design guides

## Training Design Reference

### Bloom's Taxonomy - Cognitive Domain
| Level | Description | Action Verbs |
|-------|-------------|--------------|
| Remember | Recall facts and concepts | Define, list, identify, recall |
| Understand | Explain ideas or concepts | Describe, explain, summarize |
| Apply | Use information in new situations | Apply, demonstrate, solve |
| Analyze | Draw connections among ideas | Analyze, compare, examine |
| Evaluate | Justify a decision or position | Assess, critique, evaluate |
| Create | Produce new or original work | Create, design, develop |

### Learning Objective Format (ABCD)
- **A**udience: Who will learn
- **B**ehavior: What they will be able to do
- **C**ondition: Under what circumstances
- **D**egree: How well (criterion)

Example: "Given a customer complaint (C), the service representative (A) will resolve the issue using the 5-step resolution process (B) with 90% customer satisfaction (D)."

### Training Module Template
```
MODULE: [Module Title]
Duration: [X hours]
Delivery: [Method]

OBJECTIVES:
By the end of this module, participants will be able to:
1. [Objective 1]
2. [Objective 2]
3. [Objective 3]

CONTENT OUTLINE:
1. Introduction (X min)
   - Learning objectives
   - Relevance to role
2. Topic 1 (X min)
   - Content
   - Activity
3. Topic 2 (X min)
   - Content
   - Activity
4. Practice (X min)
   - Scenario/exercise
5. Assessment (X min)
   - Knowledge check
6. Summary (X min)
   - Key takeaways
   - Next steps

MATERIALS:
- Slides
- Participant guide
- Job aids
- Assessment
```

### Blended Learning Mix
| Component | Purpose | Examples |
|-----------|---------|----------|
| Self-paced | Knowledge acquisition | e-Learning, videos, reading |
| Instructor-led | Complex concepts, Q&A | Classroom, virtual sessions |
| Practice | Skill development | Simulations, role plays |
| Social | Peer learning | Discussion forums, cohorts |
| On-the-job | Application | Assignments, projects |
| Coaching | Individual support | 1:1 sessions, mentoring |

### Training Effort Estimation
| Activity | Development Ratio |
|----------|------------------|
| Instructor-led | 40:1 (40 hrs dev per 1 hr delivery) |
| e-Learning (basic) | 80:1 |
| e-Learning (interactive) | 180:1 |
| Video | 20:1 |
| Job aids | 10:1 |

### Assessment Types
| Type | Purpose | When to Use |
|------|---------|-------------|
| Pre-assessment | Baseline knowledge | Before training |
| Knowledge check | Retention during training | End of modules |
| Post-assessment | Learning validation | End of training |
| Skills demonstration | Application ability | After practice |
| On-the-job observation | Transfer of learning | Weeks after training |

### Kirkpatrick Evaluation Model
| Level | Measures | Methods |
|-------|----------|---------|
| 1 - Reaction | Satisfaction | Surveys, feedback forms |
| 2 - Learning | Knowledge/skills gained | Assessments, demonstrations |
| 3 - Behavior | Application on the job | Observation, manager feedback |
| 4 - Results | Business impact | Metrics, KPIs |
