---
name: treatment-writing
id: SK-FTV-002
version: 1.0.0
description: Develop narrative synopses that tell the complete story cinematically, serving as sales documents and production blueprints
specialization: film-tv-production
---

# Treatment Writing Skill

## Purpose

Write compelling narrative treatments that tell your complete story in prose form. Treatments serve as sales documents (to attract talent and financing) and production blueprints (to communicate the vision). They must be engaging to read while conveying the full scope of the narrative.

## Treatment Structure

### Header Section
```markdown
# [TITLE]
A [genre] [format] treatment

Written by [Author]
[Date] | [Draft Version]

---

**Logline:** [One-sentence hook]

**Tone:** [Tonal description with references]

**Theme:** [Core thematic statement]
```

### Body Structure

| Section | Purpose | Length |
|---------|---------|--------|
| Opening Image | First visual, sets tone | 1 paragraph |
| Setup | World, protagonist, status quo | 1-2 pages |
| Inciting Incident | Disruption, story kicks off | 1-2 paragraphs |
| Act One | Rising action, stakes | 1-2 pages |
| Midpoint | Major revelation/shift | 1-2 paragraphs |
| Act Two | Complications, escalation | 2-3 pages |
| Climax | Final confrontation | 1-2 paragraphs |
| Resolution | New equilibrium | 1 paragraph |
| Closing Image | Final visual, mirrors opening | 1 paragraph |

## Writing Style

### Do
- Present tense, active voice
- Third person (usually)
- Cinematic language—describe what we SEE and HEAR
- Include key dialogue moments (sparingly)
- Convey emotional journey
- Create visual setpieces
- Maintain genre tone throughout
- End acts on hooks

### Don't
- Use screenplay format
- Include camera directions
- Over-explain motivation
- Include every scene
- Use passive voice
- Tell instead of show
- Break the fourth wall

## Cinematic Writing

### Show, Don't Tell

**Bad:**
"John is angry about his father's death and wants revenge."

**Good:**
"John stands before his father's grave, rain streaming down his face. He pulls a photograph from his pocket—his father, smiling, at John's graduation. John's jaw tightens. He crumples the photo in his fist and turns away."

### Visual Setpieces

Describe major visual moments that define your film:

```markdown
The helicopter chase through the neon-lit canyons of downtown Tokyo,
weaving between skyscrapers as searchlights paint the night sky.
Sarah clings to the landing strut, wind tearing at her clothes,
as below, the city stretches to infinity—a glittering circuit board
of lights and shadow.
```

### Dialogue Snippets

Use sparingly for key moments:

```markdown
Marcus steps forward, hand outstretched. "We can end this. Together."

Elena's eyes harden. "Some things can't be forgiven, Marcus.
Some things can only be avenged."
```

## Length Guidelines

| Format | Treatment Length |
|--------|-----------------|
| Short Film | 2-3 pages |
| Feature | 5-15 pages |
| TV Pilot | 8-12 pages |
| Limited Series | 15-25 pages (all episodes) |
| Episode | 3-5 pages |

## Act Structure Templates

### Three-Act (Feature)

**ACT ONE (Setup) - 25%**
- Opening image
- Introduction of protagonist in their world
- Inciting incident
- Debate/refusal
- Crossing the threshold

**ACT TWO (Confrontation) - 50%**
- "Fun and games" - exploring the premise
- B-story development
- Midpoint revelation
- Rising stakes
- All is lost moment
- Dark night of the soul

**ACT THREE (Resolution) - 25%**
- Break into three
- Gathering for final push
- Climax
- Resolution
- Closing image

### TV Pilot Structure

**TEASER** - The hook that grabs viewers
**ACT ONE** - Establish world and characters
**ACT TWO** - Inciting incident and complications
**ACT THREE** - Escalation and midpoint
**ACT FOUR** - Crisis and decision
**ACT FIVE** - Climax and cliffhanger

## Output Format

```markdown
# [TITLE]

A [genre] [format] treatment

---

**Logline:** [Hook]

**Tone:** [Description with film references]

**Theme:** [Thematic statement]

---

## FADE IN:

[Opening image and setup]

---

## ACT ONE

[Act one narrative]

---

## ACT TWO

[Act two narrative, include midpoint]

---

## ACT THREE

[Climax and resolution]

---

## FADE OUT.

---

**Key Setpieces:**
- [Setpiece 1]
- [Setpiece 2]
- [Setpiece 3]

**Character Arcs:**
- [Protagonist]: [Starting state] → [Ending state]
- [Antagonist]: [Arc description]
```

## Pro Tips

1. **Read it aloud** - Treatments must flow well
2. **Hook every page** - Reader should want to turn
3. **Emotion over plot** - We invest in feelings
4. **Be specific** - Details create believability
5. **End strong** - Closing image should resonate
