---
name: triz-contradiction-solver
description: Skill for systematic innovation using TRIZ methodology
allowed-tools:
  - Read
  - Write
  - Bash
metadata:
  specialization: scientific-discovery
  domain: science
  category: Hypothesis Development
  skill-id: SK-SCIDISC-011
---

# TRIZ Contradiction Solver Skill

## Purpose

Apply TRIZ (Theory of Inventive Problem Solving) methodology for systematic innovation and resolving technical contradictions.

## Capabilities

- Identify technical contradictions
- Apply inventive principles
- Use contradiction matrix
- Generate solution concepts
- Evaluate solutions
- Document innovation process

## Usage Guidelines

1. Define the problem
2. Identify contradictions
3. Apply TRIZ principles
4. Generate solutions
5. Evaluate feasibility
6. Document outcomes

## Process Integration

Works within scientific discovery workflows for:
- Innovation challenges
- Technical problem solving
- Design optimization
- Creative solutions

## Configuration

- Contradiction parameters
- Principle selection
- Evaluation criteria
- Output formatting

## Output Artifacts

- Contradiction analyses
- Solution concepts
- Principle applications
- Innovation reports
