---
name: turing-machine-simulator
description: Simulate Turing machines for computability analysis and algorithm demonstration
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: computer-science
  domain: science
  category: complexity-theory
  phase: 6
---

# Turing Machine Simulator

## Purpose

Provides expert guidance on simulating Turing machines for computability analysis, decidability proofs, and algorithm demonstration.

## Capabilities

- Multi-tape TM simulation
- Non-deterministic TM simulation
- Step-by-step execution with tape visualization
- Halting detection with timeout
- Generate computation traces
- Universal TM simulation

## Usage Guidelines

1. **TM Specification**: Define Turing machine formally
2. **Simulation Setup**: Configure simulation parameters
3. **Execution**: Run simulation with visualization
4. **Analysis**: Analyze computation trace
5. **Documentation**: Generate execution report

## Tools/Libraries

- TM specification languages
- Visualization tools
- Computation trace analyzers
