---
name: type-inference-engine
description: Implement and test type inference algorithms including Algorithm W and constraint-based inference
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: computer-science
  domain: science
  category: programming-language-theory
  phase: 6
---

# Type Inference Engine

## Purpose

Provides expert guidance on implementing type inference algorithms for programming language implementations.

## Capabilities

- Algorithm W implementation
- Constraint generation and solving
- Unification with occurs check
- Let-polymorphism (Hindley-Milner)
- Principal type computation
- Type error diagnosis

## Usage Guidelines

1. **Constraint Generation**: Generate type constraints from expressions
2. **Unification**: Implement unification algorithm
3. **Generalization**: Handle let-polymorphism
4. **Error Messages**: Generate informative type errors
5. **Testing**: Validate inference on test cases

## Tools/Libraries

- Language workbenches
- Constraint solvers
- Type inference libraries
